//
//  CRFramerImage.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 3/24/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRFramer.h"
#import "CRCompositeOperation.h"
#import "CRTextureAdapter.h"

extern NSString* const CRFramerImagePhotoPlaceKey;
extern NSString* const CRFramerImageCompositeOperationKey;

//////////////////////////////////////////////////////////////////////
// Single-image frame generator, pushes material over the photo with
// specified composite operation
//////////////////////////////////////////////////////////////////////
@interface CRFramerImage : CRFramer
{
	NSArray*			availableCompositeOperations;
	CRTextureAdapter*	adapterFrame;
}

@property (nonatomic, readonly) CRTextureAdapter*	adapterFrame;
@property (nonatomic, readonly)	NSArray*			availableCompositeOperations;
@property (nonatomic, assign)	NSUInteger			selectedCompositeOperation;
@property (nonatomic, assign)	NSRect				photoPlace;

@end